<?php

namespace Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator;

use Drupal\Core\Url;

/**
 * Class SitemapWriter
 * @package Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator
 */
class SitemapWriter extends \XMLWriter {

  const GENERATED_BY = 'Generated by the Simple XML Sitemap Drupal module: https://drupal.org/project/simple_sitemap.';
  const XML_VERSION = '1.0';
  const ENCODING = 'UTF-8';

  /**
   * Adds the XML stylesheet to the XML page.
   */
  public function writeXsl() {
    $xsl_url = Url::fromRoute('simple_sitemap.sitemap_xsl')->toString();
    $this->writePI('xml-stylesheet', 'type="text/xsl" href="' . $xsl_url . '"');
  }

  public function writeGeneratedBy() {
    $this->writeComment(self::GENERATED_BY);
  }

  public function startSitemapDocument() {
    $this->startDocument(self::XML_VERSION, self::ENCODING);
  }

}
