<?php

    use Drupal\node\Entity\NodeType;
    use Drupal\Core\Form\FormStateInterface;

    function admin_form_system_theme_settings_alter(&$form, FormStateInterface &$form_state) {

        $form['admin_settings'] = array(
            '#type' => 'fieldset',
            '#title' => t('Admin Theme Settings'),
            '#collapsible' => FALSE,
            '#collapsed' => FALSE,
        );

        $form['admin_settings']['tabs'] = array(
            '#type' => 'vertical_tabs',
            '#default_tab' => 'basic_tab',
        );

        $form['admin_settings']['basic_tab']['basic_settings'] = array(
            '#type' => 'details',
            '#title' => t('Basic Settings'),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
            '#group' => 'tabs',
        );

        $form['admin_settings']['basic_tab']['basic_settings']['node_form_meta'] = array(
            '#type' => 'item',
            '#markup' => '<div class="theme-settings-title">'.t("Node form meta block position").'</div>',
        );

        $form['admin_settings']['basic_tab']['basic_settings']['node_form_meta'] = array(
            '#type' => 'checkbox',
            '#title' => t('Display block meta as vertical tabs'),
            '#description'   => t('Use the checkbox to display the node meta block as vertical tabs and under the main node form.'),
            '#default_value' => theme_get_setting('node_form_meta', 'admin'),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $options = array_map(function (NodeType $nodeType) { return $nodeType->label(); }, NodeType::loadMultiple());
        $default_value = theme_get_setting('node_form_meta_types', 'admin');
        $form['admin_settings']['basic_tab']['basic_settings']['node_form_meta_types'] = array(
            '#type' => 'checkboxes',
            '#title' => t('Select the content types'),
            '#description'   => t('Select the content type on which display the node meta block as vertical tabs and under the main node form.'),
            '#default_value' => $default_value ? array_filter($default_value) : [],
            '#options' => $options,
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
            '#states' => [
                'visible' => [
                    ':input[name="node_form_meta"]' => ['checked' => TRUE],
                ],
            ]
        );

    }