jQuery(document).ready(function () {
    jQuery('.trip-page .button').click(function () {
        if (jQuery(this).hasClass('expanded')) {
            jQuery('span', this).text('rozwiń');
            jQuery(this).removeClass('expanded')
            jQuery('.trip-page .collapse').slideUp(300);
        } else {
            jQuery('span', this).text('zwiń');
            jQuery('.trip-page .collapse').slideDown(300);
            jQuery(this).addClass('expanded');
        }
    });

    jQuery('.trip-page .button.expanded').click(function () {
        jQuery(this).removeClass('expanded');
        jQuery('.trip-page .collapse').slideUp(300);
    });

    OrphansAndWidows('p');
    OrphansAndWidows('h1');
    OrphansAndWidows('h2');

    jQuery('#nav-icon').off('click').click(function(){
        jQuery(this).toggleClass('open');
        jQuery('#block-menu > ul').slideToggle(400, 'swing');
        jQuery('#block-menu > ul > li').removeClass('open');
    });

    jQuery('.front .slider').slick({
        arrows: true,
        dots: false,
        autoplay: true,
        fade: true,
        appendArrows: '.slider-arrows',
        prevArrow: '<span class="prev arrow">w lewo</span>',
        nextArrow: '<span class="next arrow">w prawo</span>',
    });

    jQuery('.front .journal-slider .slides').slick({
        arrows: false,
        dots: false,
        // autoplay: true,
        // centerMode: true,
        // centerPadding: '20%'
    });

    jQuery('#block-previous-trips .previous-trips').slick({
        slidesToShow: 2,
        slidesToScroll: 1
    });


    jQuery(window).scroll(function () {
        var fromTop = jQuery(document).scrollTop();
        if (fromTop > 200) {
            jQuery('header nav').addClass('scroll');
        } else {
            jQuery('header nav').removeClass('scroll');
        }
    });

    var filter;

    jQuery('.menu .filter').click(function () {
        // if (jQuery(this).data('filter') != 'all') {
        filter = jQuery(this).data('filter');

        // jQuery('.support-item').parent().fadeOut();
        jQuery('.menu .dishes').fadeOut().promise().done(function () {
            // AOS.refresh();
            jQuery('.menu .dishes').filter('[data-filter="' + filter + '"]').fadeIn();
            // window.location.hash = '#'+filter;
        });
        jQuery('.menu .active').removeClass('active');
        jQuery(this).addClass('active');
    });

    if (jQuery('.gallery.masonry').length > 0) {
        setTimeout(function () {
            jQuery('.gallery.masonry').masonry({
                itemSelector: '.masonry-item',
                columnWidth: '.masonry-sizer',
                percentPosition: true,
                // gutter: 10
            });
        }, 100);
    }
});

function OrphansAndWidows(container) {
    var content = jQuery(container);
    for (var i = 0; i < content.length; i++) {
        var tekst = content[i].innerHTML;
        //tekst = tekst.replace(/(\s)([^<][\S]{2})[\s]+/g,"$1$2&nbsp;"); //trzyznakowe
        tekst = tekst.replace(/(\s)([^<][\S]{1})[\s]+/g, "$1$2&nbsp;"); //dwuznakowe
        tekst = tekst.replace(/(\s)([\S])[\s]+/g, "$1$2&nbsp;"); //jednoznakowe
        content[i].innerHTML = tekst;
    }

}